/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.entity;

import dev.xkmc.curseofpandora.content.entity.WindBladeWeapon;
import dev.xkmc.curseofpandora.init.data.CoPDamageTypeGen;
import dev.xkmc.curseofpandora.init.registrate.CoPEntities;
import dev.xkmc.l2damagetracker.contents.attributes.WrappedAttribute;
import dev.xkmc.l2damagetracker.init.L2DamageTracker;
import dev.xkmc.l2library.util.math.MathHelper;
import dev.xkmc.l2serial.serialization.SerialClass;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

@SerialClass
public class WindBladeEntity
extends ThrowableProjectile
implements IEntityAdditionalSpawnData {
    @SerialClass.SerialField
    public float damage = 3.0f;
    @SerialClass.SerialField
    public int last = 200;
    @SerialClass.SerialField
    public float zrot = 0.0f;
    @SerialClass.SerialField
    private ItemStack issuer = ItemStack.f_41583_;

    public WindBladeEntity(EntityType<? extends WindBladeEntity> type, Level w) {
        super(type, w);
    }

    public WindBladeEntity(Level w) {
        this((EntityType<? extends WindBladeEntity>)((EntityType)CoPEntities.WIND_BLADE.get()), w);
    }

    protected void m_8097_() {
    }

    public void setProperties(float damage, int last, float zrot, ItemStack issuer) {
        this.damage = damage;
        this.last = last;
        this.zrot = zrot;
        this.issuer = issuer;
        Vec3 vector3d = this.m_20184_();
        float f = Mth.m_14116_((float)((float)MathHelper.horSq((Vec3)vector3d)));
        this.m_146926_((float)(Mth.m_14136_((double)vector3d.f_82480_, (double)f) * 57.2957763671875));
        this.m_146922_((float)(Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_) * 57.2957763671875));
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
    }

    public void m_8119_() {
        SimpleParticleType simpleParticleType;
        Item item;
        Vec3 velocity = this.m_20184_();
        super.m_8119_();
        this.m_20256_(velocity);
        --this.last;
        if (this.last <= 0) {
            this.m_146870_();
        }
        if ((item = this.issuer.m_41720_()) instanceof WindBladeWeapon) {
            WindBladeWeapon weapon = (WindBladeWeapon)item;
            simpleParticleType = weapon.getParticle();
        } else {
            simpleParticleType = ParticleTypes.f_123797_;
        }
        SimpleParticleType particle = simpleParticleType;
        double vx = velocity.f_82479_;
        double vy = velocity.f_82480_;
        double vz = velocity.f_82481_;
        for (int i = 0; i < 4; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)particle, this.m_20185_() + vx * (double)i / 4.0, this.m_20186_() + vy * (double)i / 4.0, this.m_20189_() + vz * (double)i / 4.0, 0.0, 0.0, 0.0);
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        if (!this.m_9236_().f_46443_) {
            DamageSource source;
            Entity entity = result.m_82443_();
            Entity owner = this.m_19749_();
            Item item = this.issuer.m_41720_();
            if (item instanceof WindBladeWeapon) {
                WindBladeWeapon weapon = (WindBladeWeapon)item;
                source = weapon.getSource(this, owner);
            } else {
                source = new DamageSource(CoPDamageTypeGen.forKey(this.m_9236_(), CoPDamageTypeGen.WIND_BLADE), entity, owner);
            }
            float dmg = this.damage;
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof Player) {
                Player player = (Player)entity2;
                double cr = ((WrappedAttribute)L2DamageTracker.CRIT_RATE.get()).getWrappedValue((LivingEntity)player);
                double cd = ((WrappedAttribute)L2DamageTracker.CRIT_DMG.get()).getWrappedValue((LivingEntity)player);
                double strength = ((WrappedAttribute)L2DamageTracker.BOW_STRENGTH.get()).getWrappedValue((LivingEntity)player);
                if (player.m_217043_().m_188500_() < cr) {
                    strength *= 1.0 + cd;
                }
                dmg *= (float)strength;
            }
            entity.m_6469_(source, dmg);
            if (owner instanceof LivingEntity) {
                this.m_19970_((LivingEntity)owner, entity);
            }
            if ((entity2 = this.issuer.m_41720_()) instanceof WindBladeWeapon) {
                WindBladeWeapon weapon = (WindBladeWeapon)entity2;
                weapon.onHit(this);
            } else {
                this.m_146870_();
            }
        }
    }

    protected void m_8060_(BlockHitResult hit) {
        super.m_8060_(hit);
        if (!this.m_9236_().f_46443_) {
            Item item = this.issuer.m_41720_();
            if (item instanceof WindBladeWeapon) {
                WindBladeWeapon weapon = (WindBladeWeapon)item;
                weapon.onHit(this);
            }
            this.m_146870_();
        }
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getZRot() {
        return this.zrot;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.zrot);
        buffer.writeItemStack(this.issuer, true);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.zrot = additionalData.readFloat();
        this.issuer = additionalData.m_130267_();
    }

    public ItemStack getStack() {
        return this.issuer;
    }

    public void m_37251_(Entity user, float xr, float yr, float angle, float v, float rand) {
        float f = -Mth.m_14031_((float)(yr * ((float)Math.PI / 180))) * Mth.m_14089_((float)(xr * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((xr + angle) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(yr * ((float)Math.PI / 180))) * Mth.m_14089_((float)(xr * ((float)Math.PI / 180)));
        this.m_6686_(f, f1, f2, v, rand);
        Vec3 vec3 = user.m_20184_();
        if (vec3.m_82553_() < (double)v * 0.75) {
            return;
        }
        this.m_20256_(this.m_20184_().m_82520_(vec3.f_82479_, user.m_20096_() ? 0.0 : vec3.f_82480_, vec3.f_82481_));
    }
}

